# Code in support of "Direct Discrete Optimization of Variational Autoencoders with Binary Latents"

## Overview

The `tvem` directory contains code for our Truncated Variational Expectation Maximization framework, which implements
the TVAE model presented in the paper (as well as Binary Sparse Coding), and our EA-based training algorithm.

The `tvae_experiments` directory contains one subdirectory per experiment described in the paper.
After following the instructions in the "Setup" section of this document, you will be able to run these experiments
by running `snakemake` from the corresponding directory.

The code has only been tested on Linux systems.

## Setup

As a first step, you must install [conda](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

Then run these commands in your shell to setup the environment:

```bash
$ conda env create
$ conda activate tvae-paper
$ cd tvem && python setup.py build_ext --inplace && conda develop . && cd ..
```

## Run an experiment

To run the experiments (optionally, on GPU by setting the `TVEM_GPU` environment variable):

```bash
$ cd tvae_experiments/<exp>
$ [env TVEM_GPU=0] snakemake
```

The denoising experiments additionally require to specify which configuration to run:

```bash
$ cd tvae_experiments/denoising
$ [env TVEM_GPU=0] snakemake --configfile confs/<desired_exp_config>
```

## Notes

- as the full dataset would be too large, for the `natims_vs_bsc` experiment (training TVAE and BSC on natural image patches) we only provide a smaller dataset of 10k datapoints. The full dataset of 100k datapoints can be made available upon request.
- similarly, in the original experiment, in order to speed up BSC training, we initialized the model to known good parameters. A file containing such parameters can be made available upon request.
- all experiments can in principle run on a laptop, but the largest require modern GPUs to run in reasonable time
